# **The Shot Line**

[![Website screenshot][image1]](https://www.theshotline.org/)

### **Reviewed by:** Madison Watkins 

### **Review date:** March 19, 2025 

### **Site Link**: [https://www.theshotline.org/](https://www.theshotline.org/)

### **Archive Link:** [http://archive.today/YJcDt](http://archive.today/YJcDt)

### **Keywords:** Contemporary, Activism and Advocacy, Artificial Intelligence, Public Humanities, Political Science 

### **Data Sources:** 
* Gun Violence Archive   
* Testimonies of individuals impacted by gun violence  
* Public data and records on gun-related incidents

### **Processes:** 
* Weaving individual stories into broader data narratives  
* Reconstructing the voices of people killed by gun violence using AI  
* Designing an interactive system that lets users send AI-generated calls directly to representatives

### **Presentation:** 
The Shot Line is a digital memorial and political tool that uses AI to resurrect the voices of individuals killed by gun violence, enabling them to speak directly to lawmakers. Created through a collaboration between the gun control advocacy groups *Change the Ref*, founded by the parents of Joaquin Oliver, who was killed in the Parkland shooting, and *March For Our Lives*, the project turns digital storytelling into political confrontation.
<br>
The site’s interface is minimal and intentionally focused. Visitors are greeted by the recreated voice of Joaquin Oliver, delivering a chilling, posthumous message calling for gun reform. Below the video, users can enter their zip code to send the same message to their congressional representatives. The structure is more symbolic than archival, less about browsing and more about impact.
<br>
Unlike traditional digital archives, The Shot Line doesn’t categorize stories or display data visually. There are no filters by location or type of violence, no timeline of events, and no space to submit personal stories. Instead, the site hinges on one voice, one message, and one call to action

### **Digital Tools Used:** 
* AI voice generation technology  
* Web-based interactive interface for user engagement

### **Languages:** 
* English

### **Review**
The Shot Line stands at the intersection of digital storytelling, artificial intelligence, and civic action. It reframes memorialization as a tool for political pressure, resurrecting the silenced voices of gun violence victims to speak directly to lawmakers. What makes this project especially potent is its collaborative foundation—engineers, activists, families of victims, and advocacy groups have co-created a system that blends technical innovation with deep emotional resonance.

<br>
Rather than present a comprehensive or archival narrative, the site chooses a singular, targeted approach. Each visitor hears the voice of Joaquin Oliver, recreated using AI, delivering a posthumous message that becomes a direct call to action. The emotional intensity of this experience is amplified by its simplicity: listen, enter your zip code, and send the message. The Shot Line also draws power from its integration of real-time data from the Gun Violence Archive, giving weight and urgency to the narrative without overwhelming users with statistics. This balance between data and personal testimony makes the project both credible and deeply human.

<br>
What distinguishes the project even further is its emphasis on user empowerment. The interactive “send-a-call” feature transforms passive witnessing into immediate civic engagement. It’s advocacy made accessible.

<br>
Still, there’s room to expand. The addition of an interactive map showing the locations of shootings tied to legislative districts could deepen the project’s political dimension. Real-time updates on related policy efforts would help users see the impact of their engagement. Further collaboration with digital cartographers, educators, and AI ethicists could also enrich both the technological and ethical framework of the site.

### **How are the collaborative aspects reflected in the project and are there elements that work particularly well?** 
The collaborative nature of The Shot Line is evident in both its structure and purpose. From a technical standpoint, the integration of AI-generated voices with real human testimonies represents a seamless partnership between developers and communities directly impacted by gun violence. Families of victims, digital activists, and engineers came together to create a tool that goes beyond commemoration, it actively demands change.

<br>
The partnership with *Change the Ref* and *March For Our Lives* is central to this collaboration, combining the emotional power of storytelling with the strategic know-how of grassroots political organizing. These partnerships are crucial in extending the project's reach and mobilizing collective action. The integration of data from the Gun Violence Archive further strengthens the project by grounding it in credible, updated statistics.

<br>
One of the most effective elements is the call-to-action button that allows users to send AI-generated calls to Congress. This is not only a technical achievement but also a brilliant example of collaborative design that bridges user engagement with civic responsibility. It empowers users to join a larger movement without needing prior experience in advocacy or tech.

### **Do you see an opportunity for collaboration that would be helpful to the project?** 
Absolutely. Expanding The Shot Line through partnerships with advocacy groups, educators, and international organizations could broaden its impact. Collaborations with schools and universities could integrate the project into curricula focused on civics, ethics, or digital humanities, encouraging student participation and awareness.

<br>
In terms of technology, partnering with data visualization experts or digital cartographers could lead to the development of a national map that tracks gun violence patterns alongside legislation. Working with sound designers or voice technologists could also deepen the emotional realism of the AI-generated voices, creating a more immersive user experience.

<br>
Ultimately, The Shot Line stands out as a deeply collaborative digital memory and advocacy project. It combines the emotional gravity of personal stories with the immediacy of political engagement. By doing so, it sets a powerful precedent for how public humanities projects can intersect with activism and artificial intelligence to drive social change.

[image1]: <data:image/png;base64,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>